import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ObservableListDemo {
	public static void main(String[] args) {

		final ObservableList<String> ols = FXCollections.observableArrayList();
		
		ols.addListener(new ListChangeListener<String>() {
			@Override
			public void onChanged(ListChangeListener.Change<? extends String> c) {
				int change = 0;
				while (c.next()) {
					change++;
					if (c.wasRemoved())
						System.out.println("Removed-Veränderung " + change + ", entfernt: " + c.getRemoved());
					if (c.wasAdded())
						System.out.println("Added-Veränderung " + change +
								", betroffen: von " + c.getFrom() + " bis " + (c.getTo()-1) +
								", ergänzt: " + c.getAddedSubList());
				}
			}
		});
		
		System.out.println("Elemente aufnehmen:");
		ols.addAll("A", "B", "C", "D", "E", "F");

		System.out.println("\nHintereinander liegende Elemente entfernen:");
		ols.removeAll("D", "E", "F");

		System.out.println("\nEin Element ersetzen:");
		ols.set(0, "A1");

		System.out.println("\nNicht hintereinander liegende Elemente entfernen:");
		ols.removeAll("A1", "C");
	}
}
